import { jsx, jsxs } from "react/jsx-runtime";
import { C as Combobox } from "./combobox-BCj7gyvQ.js";
import { I as InputError } from "./input-error-CBKwRgzN.js";
import { L as LoadingButton } from "./loading-button-C9msud_X.js";
import { C as Card } from "./card-DBOrqCcU.js";
import { I as Input } from "./input-BPdrsFAc.js";
import { L as Label } from "./label-BKAgVFnB.js";
import { R as RadioGroup, a as RadioGroupItem } from "./radio-group-B7ePM9gk.js";
import { S as Select, a as SelectTrigger, b as SelectValue, c as SelectContent, d as SelectItem } from "./select-DLRJE4Jo.js";
import { T as Textarea } from "./textarea-M8ToDCeU.js";
import { c as courseLanguages } from "./course-languages-oEC7DuVF.js";
import { D as DashboardLayout } from "./layout-Coo-00Zo.js";
import { o as onHandleChange } from "./inertia-BtwbgBI3.js";
import { usePage, useForm } from "@inertiajs/react";
import { useMemo } from "react";
import { Editor } from "richtor";
/* empty css                 */
import "./button-CoRGprmX.js";
import "@radix-ui/react-slot";
import "class-variance-authority";
import "./utils-Dq7odfJT.js";
import "clsx";
import "tailwind-merge";
import "cmdk";
import "lucide-react";
import "./popover-BomUxjap.js";
import "@radix-ui/react-popover";
import "@radix-ui/react-label";
import "@radix-ui/react-radio-group";
import "@radix-ui/react-select";
import "./sidebar-4chFkdEZ.js";
import "./separator-BjFPAtSa.js";
import "@radix-ui/react-separator";
import "./sheet-BrIPI26w.js";
import "@radix-ui/react-dialog";
import "./tooltip-BatcEs-T.js";
import "@radix-ui/react-tooltip";
import "./main-BlfvuptM.js";
import "./sonner-0gqP4YyH.js";
import "next-themes";
import "sonner";
import "./appearance-B5i6uI_j.js";
import "./dropdown-menu-DONmDWr6.js";
import "@radix-ui/react-dropdown-menu";
import "./language-pQjimNcB.js";
import "./notification-Bii6lhkq.js";
import "date-fns";
import "./scroll-area-Dgj2o23v.js";
import "@radix-ui/react-scroll-area";
import "./app-logo-CP8LgHIG.js";
import "./accordion-DjZKTuzo.js";
import "@radix-ui/react-accordion";
import "./route-DlE7FdTW.js";
import "./avatar-DPWl5zBC.js";
import "@radix-ui/react-avatar";
import "./use-lang-44ndmTOc.js";
const Basic = () => {
  const { props } = usePage();
  const { auth, system, tab, labels, categories, course, instructors, translate } = props;
  const { input, button, common } = translate;
  const { data, setData, post, errors, processing } = useForm({
    tab,
    title: course.title,
    short_description: course.short_description,
    description: course.description,
    status: course.status,
    level: course.level,
    language: course.language,
    instructor_id: course.instructor_id,
    drip_content: Boolean(course.drip_content),
    course_category_id: course.course_category_id,
    course_category_child_id: course.course_category_child_id
  });
  const handleSubmit = (e) => {
    e.preventDefault();
    post(route("courses.update", { id: course.id }));
  };
  const transformedCategories = useMemo(() => {
    return categories.flatMap((category) => {
      var _a;
      const categoryItem = {
        id: category.id,
        label: category.title,
        value: category.title,
        child_id: ""
      };
      const childItems = ((_a = category.category_children) == null ? void 0 : _a.map((child) => ({
        id: child.course_category_id,
        label: `--${child.title}`,
        value: child.title,
        child_id: child.id
      }))) || [];
      return [categoryItem, ...childItems];
    });
  }, [categories]);
  const transformedInstructors = instructors == null ? void 0 : instructors.map((instructor) => ({
    label: instructor.user.name,
    value: instructor.id
  }));
  let selectedCategory;
  categories.map((category) => {
    var _a;
    if (course.course_category_child_id) {
      (_a = category.category_children) == null ? void 0 : _a.map((child) => {
        if (child.id === data.course_category_child_id) {
          selectedCategory = child;
          return;
        }
      });
    } else {
      if (category.id === data.course_category_id) {
        selectedCategory = category;
        return;
      }
    }
  });
  return /* @__PURE__ */ jsx(Card, { className: "container p-4 sm:p-6", children: /* @__PURE__ */ jsxs("form", { onSubmit: handleSubmit, className: "space-y-4", children: [
    /* @__PURE__ */ jsxs("div", { children: [
      /* @__PURE__ */ jsxs(Label, { children: [
        input.title,
        " *"
      ] }),
      /* @__PURE__ */ jsx(Input, { name: "title", value: data.title, onChange: (e) => onHandleChange(e, setData), placeholder: input.title_placeholder }),
      /* @__PURE__ */ jsx(InputError, { message: errors.title })
    ] }),
    /* @__PURE__ */ jsxs("div", { children: [
      /* @__PURE__ */ jsx(Label, { children: input.short_description }),
      /* @__PURE__ */ jsx(
        Textarea,
        {
          rows: 5,
          name: "short_description",
          value: data.short_description,
          onChange: (e) => onHandleChange(e, setData),
          placeholder: input.short_description_placeholder
        }
      ),
      /* @__PURE__ */ jsx(InputError, { message: errors.short_description })
    ] }),
    /* @__PURE__ */ jsxs("div", { children: [
      /* @__PURE__ */ jsx(Label, { children: input.description }),
      /* @__PURE__ */ jsx(
        Editor,
        {
          ssr: true,
          output: "html",
          placeholder: {
            paragraph: input.description_placeholder,
            imageCaption: input.description_placeholder
          },
          contentMinHeight: 256,
          contentMaxHeight: 640,
          initialContent: data.description,
          onContentChange: (value) => setData((prev) => ({
            ...prev,
            description: value
          }))
        }
      ),
      /* @__PURE__ */ jsx(InputError, { message: errors.description })
    ] }),
    auth.user.role === "admin" && system.sub_type === "collaborative" && /* @__PURE__ */ jsxs("div", { children: [
      /* @__PURE__ */ jsxs(Label, { children: [
        input.course_instructor,
        " *"
      ] }),
      /* @__PURE__ */ jsx(
        Combobox,
        {
          defaultValue: data.instructor_id,
          data: transformedInstructors || [],
          placeholder: input.instructor_placeholder,
          onSelect: (selected) => setData("instructor_id", selected.value)
        }
      ),
      /* @__PURE__ */ jsx(InputError, { message: errors.instructor_id })
    ] }),
    /* @__PURE__ */ jsxs("div", { className: "grid gap-6 md:grid-cols-2", children: [
      /* @__PURE__ */ jsxs("div", { children: [
        /* @__PURE__ */ jsxs(Label, { children: [
          input.category,
          " *"
        ] }),
        /* @__PURE__ */ jsx(
          Combobox,
          {
            data: transformedCategories,
            placeholder: input.category_placeholder,
            defaultValue: (selectedCategory == null ? void 0 : selectedCategory.title) || "",
            onSelect: (selected) => {
              setData("course_category_id", selected.id);
              setData("course_category_child_id", selected.child_id);
            }
          }
        ),
        /* @__PURE__ */ jsx(InputError, { message: errors.course_category_id })
      ] }),
      /* @__PURE__ */ jsxs("div", { children: [
        /* @__PURE__ */ jsxs(Label, { children: [
          input.course_level,
          " *"
        ] }),
        /* @__PURE__ */ jsxs(Select, { value: data.level, onValueChange: (value) => setData("level", value), children: [
          /* @__PURE__ */ jsx(SelectTrigger, { children: /* @__PURE__ */ jsx(SelectValue, { placeholder: input.course_level_placeholder }) }),
          /* @__PURE__ */ jsx(SelectContent, { children: labels.map((label) => /* @__PURE__ */ jsx(SelectItem, { value: label, className: "capitalize", children: label }, label)) })
        ] }),
        /* @__PURE__ */ jsx(InputError, { message: errors.level })
      ] }),
      /* @__PURE__ */ jsxs("div", { children: [
        /* @__PURE__ */ jsxs(Label, { children: [
          input.course_language,
          " *"
        ] }),
        /* @__PURE__ */ jsx(
          Combobox,
          {
            defaultValue: data.language,
            data: courseLanguages,
            placeholder: input.course_language_placeholder,
            onSelect: (selected) => setData("language", selected.value)
          }
        ),
        /* @__PURE__ */ jsx(InputError, { message: errors.language })
      ] }),
      /* @__PURE__ */ jsxs("div", { children: [
        /* @__PURE__ */ jsxs(Label, { children: [
          input.enable_drip_content,
          " *"
        ] }),
        /* @__PURE__ */ jsxs(
          RadioGroup,
          {
            defaultValue: data.drip_content ? "on" : "off",
            className: "flex items-center space-x-4 pt-2 pb-1",
            onValueChange: (value) => setData("drip_content", value == "on" ? true : false),
            children: [
              /* @__PURE__ */ jsxs("div", { className: "flex items-center space-x-2", children: [
                /* @__PURE__ */ jsx(RadioGroupItem, { className: "cursor-pointer", id: "off", value: "off" }),
                /* @__PURE__ */ jsx(Label, { htmlFor: "off", children: common.off })
              ] }),
              /* @__PURE__ */ jsxs("div", { className: "flex items-center space-x-2", children: [
                /* @__PURE__ */ jsx(RadioGroupItem, { className: "cursor-pointer", id: "on", value: "on" }),
                /* @__PURE__ */ jsx(Label, { htmlFor: "on", children: common.on })
              ] })
            ]
          }
        ),
        /* @__PURE__ */ jsx(InputError, { message: errors.drip_content })
      ] })
    ] }),
    /* @__PURE__ */ jsx("div", { className: "mt-8", children: /* @__PURE__ */ jsx(LoadingButton, { loading: processing, children: button.save_changes }) })
  ] }) });
};
Basic.layout = (page) => /* @__PURE__ */ jsx(DashboardLayout, { children: page });
export {
  Basic as default
};
